//LidPosts.scad;

//LidPostWithHole generates one post resting 
//on the XY plane and with its mounting hole
//centered at the origin;

//It accepts one input parameter:
//WallDeltaY;
//For the two posts on the front wall, 
//WallDeltaY = -PostLidPhi/2;
//For the two posts on the rear wall, 
//WallDeltaY = +PostLidPhi/2;
//This places the cube of the post on 
//the appropriate side of the cylinder 
//to simplify translation from the origin 
//to the appropriate wall;
//This is a little bit helpful, 
//but only a little bit helpful;

//Use LidPost four times to generate 
//four mounting posts;

include <UNO_Dimensions.scad>
use <UNO_LidPostWithHole.scad>;


module LidPosts()
{

echo("Begin LidPosts");
    
//DeltaZ is constant for all posts;
//The posts must be clear of the floor;
DeltaZ = 2*FloorZ;

//Two posts on the front wall;
echo("Post BL = ", LidBLx, LidBLy);
translate([LidBLx, LidBLy, DeltaZ])
    LidPostWithHole(-PostLidPhi/2);

echo("Post BR = ", LidBRx, LidBRy);
translate([LidBRx, LidBRy, DeltaZ])
    LidPostWithHole(-PostLidPhi/2);

//Two posts on the rear wall;
echo("Post TR = ", LidTRx, LidTRy);
translate([LidTRx, LidTRy, DeltaZ])
    LidPostWithHole(PostLidPhi/2);

echo("Post TL = ", LidTLx, LidTLy);
translate([LidTLx, LidTLy, DeltaZ])
    LidPostWithHole(PostLidPhi/2);

}
//
